/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.sct.engine.test;

import com.quantumdata.sct.dao.impl.StandardCapabilityDAO;
import com.quantumdata.sct.dao.impl.TestCapabilityDAO;
import com.quantumdata.sct.dao.impl.XMLDAOFactory;
import com.quantumdata.sct.dao.vo.StandardCapabilityVO;
import com.quantumdata.sct.dao.vo.TestCapabilityVO;
import com.quantumdata.sct.dao.vo.TestVO;
import com.quantumdata.sct.engine.test.ITestFilter;
import com.quantumdata.sct.util.SCTSelection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;

public class StandardsTestFilter
implements ITestFilter {
    private ArrayList standardCapabilityIDs;

    public StandardsTestFilter() {
        try {
            String string = SCTSelection.instance().getStandardID();
            this.standardCapabilityIDs = new ArrayList();
            StandardCapabilityDAO standardCapabilityDAO = (StandardCapabilityDAO)XMLDAOFactory.getStandardCapabilityDAO();
            StandardCapabilityVO standardCapabilityVO = (StandardCapabilityVO)standardCapabilityDAO.read(string);
            for (StandardCapabilityVO.StandardCapabilityElementVO standardCapabilityElementVO : standardCapabilityVO.getStandardElements()) {
                this.standardCapabilityIDs.add(standardCapabilityElementVO.getCapabilityId());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public Collection filter(Collection collection) throws Exception {
        if (collection == null) {
            throw new IllegalArgumentException("Test collection is null");
        }
        TestCapabilityDAO testCapabilityDAO = (TestCapabilityDAO)XMLDAOFactory.getTestCapabilityDAO();
        Vector<TestVO> vector = new Vector<TestVO>();
        for (TestVO testVO : collection) {
            TestCapabilityVO testCapabilityVO = (TestCapabilityVO)testCapabilityDAO.read(testVO.getId());
            String string = testCapabilityVO.getPrimaryCapabilityId();
            if (!this.standardCapabilityIDs.contains(string)) continue;
            vector.add(testVO);
        }
        return vector;
    }
}

